/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.service.serviceaction;

import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.service.managedsystem.VerifyException;
import com.ibm.hwmca.fw.service.serviceaction.ProblemMonitor;
import com.ibm.hwmca.fw.service.serviceaction.ProblemVerificationFilter;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class DefaultProblemVerificationFilter
implements ProblemVerificationFilter {
    private static final String TRACE_MASKT = "XRVXDPVT";
    private static final String TRACE_MASKF = "XRVXDPVF";
    private static final String TRACE_MASKD = "XRVXDPVD";

    public void test(Problem sourceProblem, ProblemMonitor problemMonitor, Map userData) throws VerifyException {
        List verifyDetectedProblems = problemMonitor.getDetectedProblems();
        CommonProblem sp = (CommonProblem)sourceProblem;
        if (verifyDetectedProblems != null) {
            VerifyException ve = new VerifyException("verify exception for problem number: " + sourceProblem.getProblemNumber() + ", key: " + sourceProblem.getUniqueKey());
            Iterator it = verifyDetectedProblems.iterator();
            while (it.hasNext()) {
                Problem p = (Problem)it.next();
                if (p instanceof CommonProblem) {
                    CommonProblem vp = (CommonProblem)p;
                    Trace.trace(TRACE_MASKD, "DefaultProblemVerificationFilter.test - checking detected problem (key: " + vp.getUniqueKey() + ")");
                    if (this.isRelatedProblem(sp, vp)) {
                        Trace.trace(TRACE_MASKD, "DefaultProblemVerificationFilter.test - detected problem IS related - testing for duplicate");
                        if (this.isIgnorableProblem(sp, vp, userData)) {
                            Trace.trace(TRACE_MASKD, "DefaultProblemVerificationFilter.test - detected problem is an ignorable problem");
                            return;
                        }
                        if (this.isDuplicateProblem(sp, vp)) {
                            Trace.trace(TRACE_MASKD, "DefaultProblemVerificationFilter.test - detected problem IS a duplicate of problem being fixed");
                            ve.addDuplicateProblem(vp);
                            continue;
                        }
                        Trace.trace(TRACE_MASKD, "DefaultProblemVerificationFilter.test - detected problem IS related, but is NOT a duplicate");
                        ve.addRelatedProblem(vp);
                        continue;
                    }
                    Trace.trace(TRACE_MASKD, "DefaultProblemVerificationFilter.test - detected problem is NOT related to the problem being fixed");
                    ve.addUnrelatedProblem(p);
                    continue;
                }
                Trace.trace(TRACE_MASKD, "DefaultProblemVerificationFilter.test - detected problem is not a CommonProblem - treating as an unrelated problem");
                ve.addUnrelatedProblem(p);
            }
            throw ve;
        }
    }

    protected abstract boolean isRelatedProblem(CommonProblem var1, CommonProblem var2);

    protected abstract boolean isDuplicateProblem(CommonProblem var1, CommonProblem var2);

    protected abstract boolean isIgnorableProblem(CommonProblem var1, CommonProblem var2, Map var3);
}

